//Listing 16.12. Przecianie operatora wejcia dla typu zdefiniowanego przez programist
#include <iostream>
using namespace std;

class String;
istream& operator >> (istream& in, String& s);

class String {
  int size; // rozmiar acucha
  char *str; // pocztek acucha wewntrznego
  void set(const char* s); // prywatny alokator
public:
friend istream& operator >> (istream& in, String& s);
  String (const char* s = "") // konstruktor domylny oraz konwertujcy
    { set(s); }
  String (const String &s) // konstruktor kopiujcy
    { set(s.str); }
  ~String() // destruktor
    { delete [ ] str; }
  String& operator = (const String& s); // przypisanie
  char* get () const // zwr wskanik na pocztek
  { return str; }
} ;

void String::set(const char* s)
{ size = strlen(s); // oblicz rozmiar
  str = new char[size + 1]; // zadaj pamici na stercie
  if (str == 0) { cout << "Brak pamici\n"; exit(0); }
  strcpy(str,s); } // skopiuj dane klienta na stert

String& String::operator = (const String& s)
{ if (this == &s) return *this; // brak operacji jeli przypisanie do tego samego obiektu
  delete [ ] str; // zwolnij istniejc pami
  set(s.str); // przydziel (ustaw) nowy obszar pamici
  return *this; } // w celu obsugi czenia w acuchu

istream& operator >> (istream& in, String& s) // globalna funkcja zaprzyjaniona
{ char name[80]; // lokalna zmienna przechowujca dane
  in >> name; // pobierz dane
  delete [] s.str; // zwolnij istniejc pami
  s.set(name); // przydziel (ustaw) nowy obszar pamici
  return cin; } // wane dla obsugi czenia w acuchu

int main ()
{
  String s; int qty; // zmienne lokalne
  cout << "Podaj nazwisko klienta oraz ilo: ";
  cin >> s >> qty; // pobierz nazwisko oraz ilo
  cout << "Nazwisko klienta: ";
  cout << s.get() << endl; // uyj metod publicznych
  cout << "Zamwiona ilo: ";
  cout << qty << endl;
  return 0;
}
